#pragma once
#include <iostream>
#include <iterator>
#include <fstream>
#include <algorithm>
#include <string>

class FileManager
{
public:
        FileManager();
        ~FileManager();

        void createData(std::ofstream& out_stream);

	void createData(std::ostream_iterator<int> it);

	template<class container>
        void loadData(container& cont, std::ifstream& in_stream);

	template<class container>
        void loadData(container& cont, std::istream_iterator<int> begin_it, std::istream_iterator<int> end_it);

	template<class container>
	void modify(container& cont);   

	template<class Iter>
	void modify(Iter begin, Iter end);

        void modify(std::istream_iterator<int> begin_it, std::istream_iterator<int> end_it, std::ostream_iterator<int> beg_out);

	template<class container>
        void outRes(const container& cont, std::ofstream& out_stream);

	template<class container>
        void outRes(const container& cont, std::ostream_iterator<int> beg_out);
};

template<class container>
inline void FileManager::loadData(container& cont, std::ifstream& in_stream) {
        typename container::value_type cur_num = 0;
        if (!in_stream.is_open()) throw new std::runtime_error("File is not opened");

	if (!cont.empty()) {
		cont.clear();
	}

	for (int i = 0; i < 100; i++) {
                in_stream >> cur_num;
                cont.push_back(cur_num);
	}
}

template<class container>
inline void FileManager::loadData(container& cont, std::istream_iterator<int> begin_it, std::istream_iterator<int> end_it) {
	if (!cont.empty()) {
		cont.clear();
	}
	cont.resize(100);

        std::copy(begin_it, end_it, cont.begin());
}

template<class container>
inline void FileManager::modify(container& cont) {
        if (cont.empty()) throw std::exception("Empty container");

        int sum = 0;
        std::for_each(cont.begin(), cont.end(), [&sum](int cur) {
                sum += cur; });
        int mean = sum / cont.size();

        std::for_each(cont.begin(), cont.end(), [&mean](auto& elem) {
                if (abs(elem) % 2) {
                        elem = elem / mean;
		}
		}
	);
}

template<class Iter>
inline void FileManager::modify(Iter begin, Iter end) {
        if (begin == end) throw std::exception("Empty container");

        int sum = 0;
	unsigned count = 0;
        std::for_each(begin, end, [&sum, &count](int cur) {
                sum += cur;
		++count;  
		}
	);
        int mean = sum / count;

        std::for_each(begin, end, [&mean](auto& elem) {
                if (abs(elem) % 2) {
                        elem = elem / mean;
		}
		}
	);
}

template<class container>
inline void FileManager::outRes(const container& cont, std::ofstream& out_stream) {
        if (!out_stream.is_open()) {
                throw std::runtime_error("File is not opened");
	}
	if (cont.empty()) {
                throw std::exception("Emty container: nothing to outut");
	}

        std::for_each(cont.begin(), cont.end(), [&out_stream](int elem) {
                out_stream << std::to_string(elem) << " "; });
}

template<class container>
inline void FileManager::outRes(const container& cont, std::ostream_iterator<int> beg_out) {
	if (cont.empty()) {
                throw std::exception("Empty container: nothing to output");
	}
        std::copy(cont.begin(), cont.end(), beg_out);
}
